/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Confidential Proprietary
 *
 * File name   : fir32.c
 * Project name: Mazatlan
 *
 * Author(s)   : Jaime Herrero
 *               Luis Reynoso
 * Department  : Guadalajara Applications Laboratory - RTAC Americas
 *
 * Description : fir32 Creation and Destruction 
 *               
 * History     :
 * 05/03/2005  : Created (A19257).
 */

#include "fir16.h"
#include "Memory\memalloc.h"

struct tFir16Struct* FIR16Create( Frac16* pCoef, uint16 u16Num){
    struct tFir16Struct* pFIR;
    
  	pFIR=(struct tFir16Struct*)memalloc(sizeof( struct tFir16Struct));
  	pFIR->pFirCoef=pCoef;
 	pFIR->iFirCoefCount=u16Num;
 	pFIR->pFirHistory=(Frac16*)memalloc((u16Num-1)*sizeof(Frac16));

    pFIR->iFirHistoryCount=0;

    return pFIR;    
}
	
void FIR16Destroy( struct tFir16Struct* pFIR){
    memfree (pFIR->pFirHistory);
    memfree (pFIR);
    return;
}
